function renderEvents(events) {
  const list = document.getElementById('event-list');
  list.innerHTML = '';
  if (!events || events.length === 0) {
    list.innerHTML = '<div class="no-events">No events captured yet.</div>';
    return;
  }
  events.slice().reverse().forEach(ev => {
    const div = document.createElement('div');
    div.className = 'event-card';
    div.innerHTML = `
      <div><b>Button:</b> ${ev.clickedElement?.text || '(unknown)'} <span style="color:#888;">(${ev.clickedElement?.tag || ''})</span></div>
      <div><b>Event:</b> <pre style="display:inline;background:none;color:#333;">${JSON.stringify(ev.eventData, null, 2)}</pre></div>
      <div class="event-time">${new Date(ev.timestamp).toLocaleTimeString()}</div>
    `;
    list.appendChild(div);
  });
}

function getEventsFromTab() {
  chrome.tabs.query({ active: true, currentWindow: true }, function(tabs) {
    if (!tabs[0]) return;
    chrome.tabs.sendMessage(tabs[0].id, { type: 'DLI_GET_EVENTS' });
  });
}

chrome.runtime.onMessage.addListener(function(msg, sender, sendResponse) {
  if (msg.type === 'DLI_EVENT') {
    window._dli_events = window._dli_events || [];
    window._dli_events.push(msg.event);
    renderEvents(window._dli_events);
  }
  if (msg.type === 'DLI_EVENT_LIST') {
    window._dli_events = msg.events || [];
    renderEvents(window._dli_events);
  }
});

document.addEventListener('DOMContentLoaded', function() {
  window._dli_events = [];
  getEventsFromTab();
}); 