function logDebug(msg) {
  // No debug log in UI
  console.log('[DLI Popup]', msg);
}
function updateToggleUI(isOn) {
  document.getElementById('inspector-toggle').checked = isOn;
  logDebug('UI updated: ' + (isOn ? 'ON' : 'OFF'));
}
function getTabKey(tabId) {
  return 'dli_tab_' + tabId;
}
document.addEventListener('DOMContentLoaded', function() {
  chrome.tabs.query({ active: true, currentWindow: true }, function(tabs) {
    const tab = tabs[0];
    if (!tab) {
      logDebug('No active tab found.');
      return;
    }
    const tabKey = getTabKey(tab.id);
    chrome.storage.local.get(tabKey, function(data) {
      const isOn = !!data[tabKey];
      logDebug('Read from storage: ' + tabKey + ' = ' + isOn);
      updateToggleUI(isOn);
      document.getElementById('inspector-toggle').onchange = function(e) {
        const setObj = {};
        setObj[tabKey] = e.target.checked;
        chrome.storage.local.set(setObj, function() {
          logDebug('Wrote to storage: ' + tabKey + ' = ' + e.target.checked);
          updateToggleUI(e.target.checked);
          chrome.tabs.reload(tab.id);
          window.close(); // Close the popup after reload is triggered
        });
      };
    });
  });
});
window.onerror = function(msg, url, line, col, err) {
  logDebug('ERROR: ' + msg + ' at ' + url + ':' + line);
}; 