(function() {
  if (!window.dataLayer) window.dataLayer = [];
  window._dli_lastClickedElement = null;
  window._dli_events = [];
  document.addEventListener('click', function(e) {
    window._dli_lastClickedElement = e.target;
  }, true);
  const origPush = window.dataLayer.push;
  window.dataLayer.push = function() {
    const eventData = arguments[0];
    let el = window._dli_lastClickedElement;
    let elInfo = el ? {
      tag: el.tagName,
      text: el.innerText || el.value || '',
      className: el.className,
      id: el.id,
      outerHTML: el.outerHTML ? el.outerHTML.slice(0, 200) : ''
    } : null;
    const payload = { type: 'DLI_EVENT', eventData, clickedElement: elInfo, timestamp: Date.now() };
    window._dli_events.push(payload);
    window.dispatchEvent(new CustomEvent('DLI_EVENT', { detail: payload }));
    return origPush.apply(this, arguments);
  };
})(); 